import React, { useState } from 'react';
import { refundDetailsStyle } from './refundDetailsStyle';
import ProgressiveImage from '../../../../../src/components/ProgressiveImage';
import CustomPhotoGallery from '../../../../../src/components/CustomImageGallery/CustomPhotoGallery';
import { Pressable } from 'react-native';

const RenderImage = ({ item, data, index }) => {
    const [isOpen, setIsOpen] = useState(false);
    return (
        <>
            <Pressable onPress={() => setIsOpen(true)}>
                <ProgressiveImage
                    source={{ uri: item }}
                    style={refundDetailsStyle.uploadPic}
                />
            </Pressable>
            <CustomPhotoGallery
                isOpen={isOpen}
                setIsOpen={setIsOpen}
                images={data}
                index={index}
            />
        </>
    );
};

export default RenderImage;
